﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "Všechny údaje shromážděné během aktivace produktu jsou používány v souladu se zásadami společnosti Autodesk. ";
var xmsgOfflinePrivacyWarning= "Pokud nejste připojeni k internetu, nastavte si kódování průzkumníku Internet Explorer (R) na automatický výběr tak, aby se zobrazily zásady ochrany osobních údajů. Pokud k internetu máte přístup, zásady osobních údajů budou dostupné i online na stránkách autodesk.com."
////////////////////////////////////////////////////

var xmsgProductLanguage=	"cs";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"Aktivace dokončena";
var xmsgRTActLicFound=                  "Byla nalezena aktivovaná licence.";
var xmsgRTActLicFoundError=            "Chyba při registraci – aktivaci"; 
var xmsgRTAuthEntryError=				"Chyba zadání aktivace";
var xmsgRTAuthError=					"Chyba aktivace";
var xmsgRTAuthNow=						"Autoriz. nyní";
var xmsgRTBeginReg=						"Možnosti aktivace";
var xmsgRTBuyInformation=				"Informace o nákupu";
var xmsgRTConfirm=						"Potvrzení uživatele";
var xmsgRTConnect=						"Požadováno připojení k Internetu";
var xmsgRTConnectFail=					"Chyba připojení";
var xmsgRTContactAutodesk=				"Kontaktovat společnost Autodesk";
var xmsgRTCountryPage=					"Země";
var xmsgRTEmail=						"E-mail";
var xmsgRTFaxUS=						"User Fax US";
var xmsgRTMailUS=						"User Mail US";
var xmsgRTPurchaseOffline=				"Nakoupit offline";
var xmsgRTRegConfirmed=					"Registrace potvrzena";
var xmsgRTExportConfirm=                "Potvrzení exportu licence";
var xmsgRTImportConfirm=                "Potvrzení importu licence"; 
var xmsgRTRegVol=						"Registrace produktu";
var xmsgRTSUNDataConfirm=				"Potvrzení SUN dat";
var xmsgRTSUNServer=					"SUN Server";
var xmsgRTSUNSubmit=					"Potvrzení/odeslání uživatele SUN";
var xmsgRTUserInfo=						"Informace o uživateli";
var xmsgRTLicFileSaveError=				"Chyba ukládání licenčního souboru Flexlm";
var xmsgRTProductInfo=                   "Požadované informace o produktu";
var xmsgNSARTBegin=						"Získat síťovou licenci";
var xmsgNSARTLocateLicense=				"Vyhledat licenční soubor";
var xmsgNSARTEditServerAndSeat=			"Zadat – Upravit server informace";
var xmsgNSARTConfirmServerAndSeat=		"Potvrdit server informace";
var xmsgNSARTEnterSN=					"Zadejte sériové číslo";
var xmsgProcessingError=				"Chyba při zpracování";
var xmsgTimeout=        				"Doba vyhrazená pro tuto relaci vypršela.";
var xmsgLicenseActivation=        		"Aktivace";
var xmsgLicenseTransfer=        		"Přenos licence";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"Aktivace pro:";
var xmsgPurchase=       "Zakoupit:";
var xmsgRegistrationFor=       "Registrace pro:";
var xmsgProduct=	"Produkt: ";
var xmsgsernum=		"Sériové číslo: ";
var xmsgsernumWGID=	"Sériové číslo: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "Klíč produktu: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"Předchozí sériové číslo: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"Předchozí sériové číslo:*";
var xmsgNewSernum1=	"Zadejte sériové číslo nebo ID skupiny:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"Kód žádosti: ";
var xmsgRegAuthCode=	"Aktivační kód: ";
var xmsgApplicationKey=	"Klíč aplikace: ";
var xmsgRTHostID=				"Hostitelské ID:";
var xmsgRTFlexlmLicenseFile=	"Licenční soubor:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Oslovení:";
var xmsgNone=		"(žádné)";
var xmsgNotEntered=	"(nezadané)";
var xmsgFirstname=	"Křestní jméno:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"Křestní jméno (Kanji):";
var xmsgFirstnameFurigana=	"Křestní jméno (Zenkaku Kana):";
var xmsgLastname=	"Příjmení:";
var xmsgLastnameKanji=	"Příjmení (Kanji):";
var xmsgLastnameFurigana=	"Příjmení (Zenkaku Kana):";
var xmsgCompanyName=	"Název společnosti:*";
var xmsgCompanyName2=	"Název společnosti:";
var xmsgCompanyNameJP=	"Název společnosti (Kanji):";
var xmsgPhone=		"Telefon:";
var xmsgArea=		"Směrové číslo:";
var xmsgNumber=		"Číslo:";
var xmsgExt=		"Rozšíření:";
var xmsgFax=		"Fax:";
var xmsgFaxTo=		"Odfaxovat na číslo ";
var xmsgEmail=		"E-mail:";
var xmsgEmailTo=	"Odeslat e-mailem na adresu ";
var xmsgAddress=	"Ulice:";
var xmsgAddress2=	"Ulice 2:";
var xmsgAddress3=	"Ulice 3:";
var xmsgJPAddress=	"Město:";
var xmsgJPAddress2=	"Ulice:";
var xmsgJPAddress3=	"Název budovy (a číslo bytu):";
var xmsgCity=		"Město:";
var xmsgSRP=		"Region/Oblast:";
var xmsgStText=		"Okres:";
var xmsgPrText=		"Okres:";
var xmsgRegText=	"Okres:";
var xmsgPrefectureText=	"Prefektura:";
var xmsgCountyText=	"Hrabství:";
var xmsgCantonText=	"Kanton:";
var xmsgZipCode=	"PSČ:";
var xmsgPostCode=	"PSČ:";
var xmsgCountry=	"Země nebo oblast:";
var xmsgDealer=		"Jméno autorizovaného prodejce produktů společnosti Autodesk:";
var xmsgMailTo=		"Poslat na ";
var xmsgAnEmail=	"e-mailovou adresu";
var xmsgAFax=		"faxové číslo";
var xmsgAMailAddress=	"poštovní adresu";
var xmsgPostalMail=		"Poštovní zásilka";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"Zpět";
var xmsgCancel=			"Zavřít";
var xmsgNext=			"Další";
var xmsgPrint=			"Tisk";
var xmsgPrintForm=		"Otevřít formulář žádosti o aktivační kód";
var xmsgNo=				"Ne";
var xmsgYes=			"Ano";
var xmsgBrowse=			"Procházet";
var xmsgDone=			"Hotovo";
var xmsgOK=				"OK";
var xmsgClose=			"Zavřít";
var xmsgSubmit=			"Odeslat";
var xmsgFinish=			"Dokončit";
var xmsgReset=			"Smazat vše";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Vyberte ";
var xmsgPleaseSelect2=		"Chcete-li svoji licenci %1 ihned aktivovat, vyberte znovu možnost „Připojit se nyní a aktivovat!“. Setkáváte-li se při aktivaci stále s problémy a přitom jste si vyžádali aktivační kód, který jste již od společnosti Autodesk obdrželi, vyberte možnost „Mám aktivační kód od společnosti Autodesk“.";
var xmsgSelectCountry=		"Země nebo oblast, ve které se bude produkt používat:";
var xmsgSelectCountry2=		"Země/Oblast:";
var xmsgInformation=		"Informace";
var xmsgCompanyInfo=		"Informace o společnosti:";
var xmsgContactInfo=		"Kontaktní informace:";
var xmsgResponseMethodInfo=	"Informace o způsobu odpovědi:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"Způsob odeslání formuláře:";
var xmsgConfirmInfo=		"Potvrdit informace";
var xmsgConfirmInfoTxt=		"Zkontrolujte následující informace. Klepněte na jeden z odkazů na způsob odeslání formuláře a použijte zobrazené informace nebo proveďte změny klepnutím na tlačítko Zpět.";
var xmsgConfirmCustIDInfoTxt=		"Potvrďte následující informace. Pokračujte stisknutím tlačítka, nebo stiskněte tlačítko zpět a proveďte změny.";
var xmsgCountryHdr=			"Registrace produktu";
var xmsgCountryRegTo=		"Tento produkt bude registrován na:";
var xmsgCountryComp=		"Společnost";
var xmsgCountryIndiv=		"Fyzickou osobu";
var xmsgCountryUpgrade=		"Jedná se o upgrade";
var xmsgCountryUpgDetail=	"(Pokud jste zákazníkem se Subscription, klepněte Ne)";
var xmsgConnectHdr1=		"Připojování";
var xmsgConnectHdr2 = "Licence k vašemu produktu se aktivuje…";
var xmsgConnectHdr = "Požadováno připojení k Internetu";
var xmsgConnectMsg=		"Spojení";
var xmsgConnectTxt=		"Nebylo zjištěno připojení k Internetu. Chcete-li provést aktivaci online, připojte se nyní k Internetu. Po navázání připojení klepněte na tlačítko Další.";
var xmsgConnectTxtOLT=    "Nebylo nalezeno žádné internetové připojení. Chcete-li licenci přesunout, připojte se nyní k Internetu.";
var xmsgConnectTxt2=	"Po připojení k Internetu klepněte na tlačítko Další.";
var xmsgConnectTxt3=	"Nemáte-li přístup k Internetu, použijte některý způsob vyžádání aktivačního kódu od společnosti Autodesk offline.";
var xmsgConnectWarming=	"Odesílání těchto informací může chvíli trvat. Počkejte.";
var xmsgTryAgain=		"Zkusit znovu";
var xmsgReEnterOld=		"Zadejte znovu předchozí sériové číslo";
var xmsgNewSernum3=		"Zadejte nové sériové číslo a klepněte Další.";
var xmsgNewSernum4=		"Zkušební verze programu byla instalována se sériovým číslem (000-00000000), které nelze zaregistrovat. Pokud jste zakoupili tento program, obdrželi jste také nové sériové číslo. Pro aktivaci a používání programu musíte použít toto nové sériové číslo.";
var xmsgNewSernum5=		"Zadejte sériové číslo nebo ID skupiny:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "Zadejte klíč produktu:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"Potvrdit nové sériové číslo:";
var xmsgNewSernum8=		"Zadejte znova nové sériové číslo";
var xmsgUseOtherMethod=		"Použít jiný způsob registrace";
var xmsgContactAutodesk=	"Kontaktovat společnost Autodesk";
var xmsgContactAutodeskLink="Společnost Autodesk můžete kontaktovat klepnutím na následující odkaz:";
var xmsgContactOptions=		"kontaktní informace jsou zobrazeny dále.";

var xmsgPuchaseInfo1=		"Informace o nákupu";
var xmsgPuchaseInfo2=		"Rozhodli jste se pro nákup online."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"Klepněte na tlačítko Další pro pokračování, nebo na tlačítko Zavřít, pokud nechcete pokračovat."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"Registrace – aktivace";
var xmsgRegTitleBuy=		"Zakoupit produkty společnosti Autodesk online";
var xmsgRegTitleNSA=		"Aktivace síťové licence";
var xmsgRegInfo=		"Zákaznické informace";
var xmsgRegInfo2=		"Způsob registrace";
var xmsgRegInfo3=		"Vyberte způsob registrace a vyberte Další.";
var xmsgRegmethod1=		"Připojit přímo prostřednictím internetu";
var xmsgRegmethod3=		"Aktivační kód chci obdržet:";
var xmsgRegmethod5=		"Poštou";
var xmsgRegmethod6=		"Vyberte tlačítko Tisk a odešlete formulář na:";
var xmsgRegmethod7=		"Fax";
var xmsgRegmethod8=		"Chcete-li vytisknout formulář, který odfaxujete společnosti Autodesk na číslo %1, nejprve zvolte způsob, jakým chcete obdržet aktivační kód. Potom klepněte na tlačítko Tisk a formulář odfaxujte.";
var xmsgRegmethod9=		"E-mail";
var xmsgRegmethod10NSA=		"Vaše níže uvedené informace o registraci a licenčním serveru byly automaticky uloženy do souboru.";
var xmsgRegmethod10=		"Registrační informace byly uloženy do následujícího souboru, pomocí kterého bude dokončeno odeslání e-mailu (tento soubor neupravujte):";
var xmsgRegmethod11NSA=		"Odešlete e-mailem informační soubor registrace a licenčního serveru %1 na %2.";
var xmsgRegmethod11=		"Odešlete e-mailem informační soubor registrace %1 na %2.";
var xmsgRegmethod12=		"Neupravujte tento soubor.<p>Doporučujeme vytisknout si kopii této stránky a bezpečně ji uložit. Tyto informace budete potřebovat pro ruční dokončení e-mail procesu.<p>Můžete si vytisknout a uložit kopii těchto informací. Klepněte na Hotovo pro uzavření této aplikace.";
var xmsgRegmethod13=		"Chcete-li %1 automaticky připojit a odeslat společnosti Autodesk, klepněte na odkaz níže.";
var xmsgRegmethod14=		"Odeslat moji žádost e-mailem";
var xmsgRegmethod15=		"Poznámka: E-mailovou adresu obsluhuje automat. Nepoužívejte tuto adresu ke komunikaci e-mailem.";
var xmsgRegmethod16=		"Chcete-li se registrovat pomocí faxu nebo klasické pošty, klepněte na jeden z následujících odkazů:";
var xmsgRegmethod17=		"Chyba odeslání e-mailu";
var xmsgRegmethod18NSA=		"Nastala chyba při pokusu systému automaticky odeslat informace o registraci a licenčním serveru.";
var xmsgRegmethod18=		"Nastala chyba při pokusu systému automaticky odeslat informace o registraci.";
var xmsgRegmethod19=		"Ruční odeslání souboru e-mailem:";
var xmsgRegmethod20NSA=		"Odešlete e-mailem informační soubor registrace a licenčního serveru %1 na %2.";
var xmsgRegmethod20=		"Odešlete e-mailem informační soubor registrace %1 na %2.";
var xmsgRegmethod21=		"Neupravujte tento soubor.<p>Doporučujeme vytisknout si kopii této stránky a bezpečně ji uložit. Tyto informace budete potřebovat pro ruční dokončení e-mail procesu.<p>Můžete si vytisknout a uložit kopii těchto informací. Klepněte na Hotovo pro uzavření této aplikace.";
var xmsgRegAuthInfo=		"Možnosti aktivace licence produktu";
var xmsgRegAuthInfo1=		"Potvrzení registrace";
var xmsgRegExpConfirm=      "Potvrzení exportu licence";
var xmsgRegImpConfirm=      "Potvrzení importu licence";
var xmsgRegAuthInfo2 =      "Připojit se nyní a aktivovat! (Doporučeno)";
var xmsgRegAuthInfo2Hover = "Spojit se se společností Autodesk a ihned aktivovat licenci k produktu (vyžaduje připojení k Internetu)";
var xmsgRegAuthInfo3=		"Zadat aktivační kód"; 
var xmsgRegAuthInfo4=		"Vyberte z následujících možností:";
var xmsgRegAuthInfo4A =     "Mám aktivační kód od společnosti Autodesk.";
var xmsgRegAuthInfo4AHoverA = "Zapište aktivační kód, který jste si vyžádali a obdrželi od společnosti Autodesk.<br>Abyste si tento krok zjednodušili, vložte celý aktivační kód do prvního pole. Ostatní pole se vyplní automaticky.";
var xmsgRegAuthInfo4AHoverB = "Zadejte cestu k souboru a název souboru nebo vyhledejte aktivační soubor, který vám společnost Autodesk poskytla formou odpovědi na váš požadavek zaslaný e-mailem.";
var xmsgRegAuthInfo4B=		"Zadejte aktivační kód:"; 
var xmsgRegAuthInfo5=		"Vyberte zemi nebo region, zadejte aktivační kód a pokračujte stisknutím tlačítka Další.";
var xmsgRegAuthInfo6=		"Aktivace licence k produktu";	
var xmsgRegAuthInfo7=		"%1 byl úspěšně aktivován!";
var xmsgRegAuthInfo8=		"Potvrzení";		
var xmsgRegAuthInfo9=		"Děkujeme vám za registraci produktu společnosti Autodesk. Díky ní vám v budoucnosti budeme moci lépe pomáhat.";
var xmsgRegAuthInfo10=		"Kopie vašich aktivačních informací byla uložena do:";		
var xmsgRegAuthInfo10B=		"Kopie vašich aktivačních informací byla uložena do:";
var xmsgRegAuthInfo14=		"Blahopřejeme vám k zakoupení produktu %1. Podle podmínek vaší aktivované licence smí být ve vašem počítači spuštěn jeden či více produktů.";
var xmsgRegAuthInfo15=		"Odinstalováním produktu %1 nedojde k odebrání licence.";
var xmsgRegAuthInfo16=		"Licence je aktivní.";
var xmsgRegActLicInfo=      "Byla nalezena aktivovaná licence.";
var xmsgRegActLicInfoError=      "Chyba při registraci – aktivaci";
var xmsgRegActiveInfo=        "Zadejte nebo vyhledejte aktivační soubor:";
var xmsgRegActLicInfo1=       "V tomto počítači byla nalezena již dříve registrovaná a aktivovaná licence pro tento produkt, která se nyní používá."
var xmsgRegActLicInfo1Error= "V tomto počítači byla nalezena dříve registrovaná a aktivovaná licence pro tento produkt.\n Došlo však k neočekávané chybě (%1). Ukončete aplikaci a zopakujte akci. Pokud problém přetrvává, obraťte se na správce systému nebo na autorizovaného prodejce produktů společnosti Autodesk.";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "Export proběhl úspěšně."; //2008-01-16
var xmsgExportFail=           "Požadavek na export se nezdařil." ; //2008-01-16
var xmsgRegErrRef=            "Odkaz na chybu:"; //2008-01-17
var xmsgImportSuccess=        "Import proběhl úspěšně."; //2008-01-16
var xmsgImportFail=           "Požadavek na import se nezdařil."; //2008-01-16
var xmsgExpSucessInfo=        "Licence byla úspěšně exportována a nachází se nyní na serveru Autodesk."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "Import licence";
var xmsgExpSucessInfo1=        "Než produkt spustíte na cílovém počítači, importujte do něj licenci prostřednictvím pomůcky přenosu licencí a připravte se k zadání ID uživatele a hesla k systému Autodesk.";  //2008-01-16
var xmsgImpSucessInfo=         "Licence byla úspěšně importována; nyní můžete  začít produkt používat. "; //2008-01-16
var xmsgImpRemindInfo=         "Připomenout export"; //2008-01-16
var xmsgImpRemindInfo1=        "Po zaškrtnutí tohoto pole se vždy po ukončení aplikace zobrazí dialog s připomenutím exportu licence.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "To je užitečné, pokud licenci na tento počítač importujete dočasně a budete ji chtít přesunout zpět.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "V připomenutí je k dispozici možnost „Zobrazit dialog znovu“.";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "Klepnutím na odkaz „Opakovat akci“ požadavek znovu odešlete. ";
var xmsgImpFailMsg=            "Pokud problém přetrvává, místo importu licenci aktivujte.";

var xmsgReqfilelocMsg=       "Soubor požadavku se nachází ve složce:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"Děkujeme vám za registraci – produkt je nyní aktivován a váš licenční soubor byl uložen. Klepnutím na tlačítko Tisk můžete uchovat kopii těchto informací.";
var xmsgRegAuthInfo12=		"Vložit aktivační kód ze schránky.";
var xmsgRegAuthInfo13=		"Zadat aktivační kód ručně.";
var xmsgRegErrorActiveCode=    "<FONT color=red>Pokračujte zadáním aktivačního kódu.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>Aktivační kód je neplatný. Zkontrolujte, zda kód neobsahuje chyby.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>Pokračujte zadáním cesty a názvu aktivačního souboru.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>Pokračujte zadáním sériového čísla.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>Sériové číslo je příliš krátké.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>Pokračujte zadáním klíče produktu.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>Klíč produktu je příliš krátký.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"Registrace – chyba aktivace";
var xmsgRegErrorSystem=		"Dočasný problém systému způsobuje chyby při registraci. Klepněte na jeden z následujících odkazů."
var xmsgRegErrorPrevReg=	"Toto zadané sériové číslo je již zaregistrováno.";
var xmsgRegErrorMaxAuth=	"Překročili jste počet povolených aktivací pro tento produkt.";
var xmsgRegErrorMaxAuth2=	"Překročili jste počet licencí povolených pro tento produkt.";
var xmsgRegErrorInvalidOld=	"Sériové číslo zadané pro váš předchozí produkt není platné. Ověřte, zda je výše zobrazené předchozí sériové číslo správné. Klepněte na jeden z následujících odkazů.";
var xmsgRegErrorData=		"Došlo k problému se zadanými registračními daty. Vyberte tlačítko Zkusit znovu a ověřte a opravte zadané informace, použijte jiný způsob registrace, nebo se obraťte na společnost Autodesk.";
var xmsgRegErrorNetwork=	"Produkt, který se pokoušíte zaregistrovat, je produkt se síťovou autorizací a musí být i takto instalován. Musíte odinstalovat váš program a vybrat typ instalace „Síťová“.<p>Správné postupy pro instalaci a aktivaci síťové verze najdete v kapitole Síťová instalace v instalační příručce.";
var xmsgRegNoResponse=		"Dočasný problém způsobuje chyby při registraci online. Klepněte na jeden z následujících odkazů.";
var xmsgRegErrorAuthEntry=	"Došlo k problému s vámi zadaným aktivačním kódem. Klepněte na jeden z následujících odkazů.";
var xmsgRegErrorAuthPermission = "K aktivaci tohoto produktu společnosti Autodesk musíte mít buď oprávnění správce, nebo vám správce vašeho systému musí přidělit oprávnění na vyšší úrovni. Obraťte se na správce systému a požádejte jej o bližší informace o oprávněních správce a oprávněních na vyšší úrovni.";							
var xmsgRegErrorAuth=		"Došlo k problému s aktivačním kódem. Klepněte na jeden z následujících odkazů.";
var xmsgRegErrorFlex=		"Došlo k problému s licencí. Klepněte na jeden z následujících odkazů.";
var xmsgRegConnError=		"Chyba připojení";
var xmsgRegConnErrorTxt=	"Došlo k problému s připojením k Internetu. Klepněte na jeden z následujících odkazů.";
var xmsgRegPurchError3=		"Použijte jiný způsob nákupu";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Děkujeme vám za zakoupení softwaru společnosti Autodesk.<p>Připojení pro dokončení tohoto procesu není nyní dostupné, zřejmě kvůli nastavení vašeho systému.<p>Klepnutím na jeden z níže uvedených odkazů otevřete prohlížeč, který vám umožní úspěšně se připojit.<p>";

var xmsgAuthResellerMsg1=	"Nákup u vašeho lokálního prodejce. Kontaktujte vašeho lokálního prodejce pro dokončení vašeho nákupu.";

var xmsgLicSaveErrInfo=		"Při ukládání licenčního souboru došlo k chybě. Klepněte na jeden z následujících odkazů.";

var xmsgOnlineStoreMsg1=	"Nakupujte v online obchodě společnosti Autodesk. Pokud hledaný produkt v tomto obchodě nenajdete, obraťte se na autorizovaného prodejce.";
var xmsgOnlineStoreMsg2=    "Online prodejna";
var xmsgAuthResellerMsg2=	"Autorizovaný prodejce";
var xmsgLocateLicenseMsg1=	"Vyhledat licenční soubor";
var xmsgLocateLicenseMsg2=	"Zadejte cestu k licenčnímu souboru (nebo jej vyhledejte pomocí tlačítka Procházet) a pokračujte stisknutím tlačítka Další.";
var xmsgLocateLicenseMsg3=	"Existující licenční soubor:";
var xmsgUserContactMsg=		"Musíte zadat alespoň jeden z následujících údajů:";
var xmsgFailureMsg=		    "Váš požadavek na aktivaci online nelze zpracovat.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "Váš požadavek na aktivaci online vyvolal chybu (%1), která nedovoluje zpracování požadavku pomocí našich automatizovaných systémů.";
var xmsgRegErrorOnline=		"Klepnutím na níže uvedený odkaz „Použít jiný způsob“ vyplňte nezbytné formuláře a odešlete svoji žádost místnímu obchodnímu středisku společnosti Autodesk odpovědnému za vaši oblast. Zástupce Oddělení zákaznických služeb odpoví do dvou pracovních dnů.";
var xmsgAnotherFormSubmitMethod=    "Použít jiný způsob";
var xmsgOfflineRegistrationMethod=    "Žádost o poskytnutí aktivačního kódu pomocí metody offline";
var xmsgOfflineRegistrationMethodHover= "Připravte si žádost o  poskytnutí aktivačního kódu pro licenci k vašemu produktu a odešlete ji společnosti Audodesk  e-mailem či faxem nebo ji předejte telefonicky.";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "Doba vyhrazená pro vaši online žádost o aktivační kód vypršela."
var xmsgTimeoutMsg2=    "Klepnutím na odkaz „Zkusit znovu“ odešlete znovu online žádost. Pokud problém přetrvává, můžete klepnout na odkaz „Použít jiný způsob“ a vyplnit nezbytné formuláře a svoji žádost odeslat e-mailem, faxem nebo jinými prostředky.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Registrační údaje byly uloženy.";
var xmsgRegSunData2=		"Registrační údaje potřebné pro rozmístění klientů byly uloženy do ";
var xmsgRegSunData3=		"Předchozí sériové číslo zadané pro registraci tohoto upgrade není platné. Obraťte se na správce.";
var xmsgRegSunData4=		"Tento program musí být přeinstalován s platným předchozím sériovým číslem.";
var xmsgRegSunData5=		"Samostatná instalace pro více licencí";
var xmsgRegSunData6=		"Pro dokončení samostatné instalace pro více licencí jsou požadovány další registrační informace. Následující stránky musí:";
var xmsgRegSunData7=		"Shromáždit potřebné informace.";
var xmsgRegSunData8=		"Umožnit zadání předchozího sériového čísla, je-li požadováno pro upgrade.";
var xmsgRegSunData9=		"Uložit tyto informace na serveru pro rozmístění na všechny instalace klientů.";
var xmsgRegSunData10=		"Tento program bude registrován s použitím následujících informací. Pokračujte tlačítkem Další.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Registrace produktu";
var xmsgRegVol2=	"Vyberte možnost a klepněte na tlačítko Další:";
var xmsgRegVol3=	"Registrovat nyní – vyberte tuto volbu pro zahájení on-line registrace.";
var xmsgRegVol4=	"Registrovat později – vyberte tuto volbu pro spuštění vašeho programu.";
var xmsgRegVol5=	"Toto již nezobrazovat.";
var xmsgRegVol6=	"(Pokud si přejete provést registraci později, vyberte volbu registrace v dialogu Nápověda|O aplikaci)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Identifikace zákazníka";
var xmsgKatakana=		    "Název společnosti (Zenkaku Kana):";
var xmsgDepartment=		    "Oddělení:";
var xmsgDepartment2=		"Název oddělení:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"Na Internetu:";
var xmsgFormWebDataMsg1 = "Aktivační kód si můžete vyžádat také navštívením následujících serverů: &nbsp;&nbsp;";
var xmsgFormEmailHdr=	"E-mail:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"Fax:";
var xmsgFormFaxHdrLocal=	"Faxem místní kanceláři:";
var xmsgFormFaxHdrReg=	"Registrace faxem:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Telefon:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Poštovní zásilkou:";
var xmsgFormMailHdrLocal=	"Poštou místní kanceláři:";
var xmsgFormMailHdrReg=	"Registrace poštou:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Zakoupit software";
var xmsgFormInternetMsg=    "Chcete-li k vyžádání aktivačního kódu použít svůj webový prohlížeč, klepněte na odkaz."
var xmsgFormEmailMsg=       "E-mailová korespondence a žádosti o aktivační kódy na:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "Poskytnuté informace použije společnost Autodesk k registraci a/nebo vydání aktivačního kódu. Registrací dáváte společnosti Autodesk souhlas k poskytnutí vašich údajů autorizovaným obchodním partnerům za účelem správy licencí k produktu a ověření oprávnění. Pokud nechcete, aby společnost Autodesk poskytla vaše údaje autorizovaným obchodním partnerům pro tyto omezené účely, kontaktujte nás na adrese <a href=mailto:information@autodesk.jp>information@autodesk.jp</a>. Chcete-li opravit nebo aktualizovat své registrační údaje, můžete společnost Autodesk kontaktovat klepnutím <a %1>SEM</a>, nebo se můžete obrátit na místní kancelář společnosti Autodesk.";
			
var privacystatement = "Poskytnuté informace společnost Autodesk použije k registraci a/nebo vydání aktivačního kódu a s jejich pomocí vás bude informovat o nových produktech a službách a zajistí, abyste těžili z výhod autorizovaného zákazníka. Společnost Autodesk neprodává ani jinak neposkytuje vaše informace třetím stranám ani svým autorizovaným obchodním partnerům. Chcete-li opravit nebo aktualizovat své dříve zaregistrované zákaznické informace, můžete společnost Autodesk kontaktovat klepnutím <a %1>SEM</a>, nebo se můžete obrátit na místní kancelář společnosti Autodesk.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="Zásady ochrany osobních údajů";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) Copyright 2009 Autodesk, Inc. Všechna práva vyhrazena."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="Obvykle se sériové číslo nezobrazí, dokud nezavřete program a nerestartujete jej s oprávněními správce.";
var xmsgRebranding2="Informace o spuštění programu s oprávněními správce naleznete v dokumentaci k vašemu operačnímu systému.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "Pole označená hvězdičkou (<FONT color=red>*</FONT>) jsou povinná.";
var xmsgRegInfoMsg2= "Informace zadané na této stránce jsou uloženy společně s licencí a používají se k opakované aktivaci a inovaci produktu. Zadejte sem proto platné informace, abyste zabránili prodlevám v používání tohoto produktu.";

var xmsgLicLocationText1 = "Uložit licenční soubor pro <b>%1</b> do:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"Otázky:";

var xmsgAppUsageQ1=	"Zodpovězením následující otázky pomůžete společnosti Autodesk lépe porozumět požadavkům vašeho odvětví.";
var xmsgAppUsageQ2=	"Který z těchto oborů nejlépe popisuje hlavní obor, ve kterém pracujete?";

var xmsgAppUsageOption51=	"Konstrukce součástí pro letecký a automobilový průmysl ";
var xmsgAppUsageOption52=	"Architektonické projekty ";
var xmsgAppUsageOption53=	"Správa budov a objektů ";
var xmsgAppUsageOption54=	"Stavebnictví: Komerční objekty ";
var xmsgAppUsageOption55=	"Stavebnictví: Obytné objekty ";
var xmsgAppUsageOption56=	"Výroba vybavení budov ";
var xmsgAppUsageOption57=	"Stavebnictví / Územní plánování ";
var xmsgAppUsageOption58=	"Konstrukce výpočetní / lékařské / kancelářské techniky ";
var xmsgAppUsageOption67=	"Konstrukce spotřebních výrobků ";
var xmsgAppUsageOption59=	"Vlastnictví podnikových budov ";
var xmsgAppUsageOption92=	"Obrana ";
var xmsgAppUsageOption93=	"Konstrukce elektrických řídicích zařízení ";
var xmsgAppUsageOption94=	"Projektování elektrických systémů ";
var xmsgAppUsageOption72=	"Projektování ekologických systémů ";
var xmsgAppUsageOption95=	"Výrobky na bázi kovových konstrukcí ";
var xmsgAppUsageOption96=	"Návrh interiérů ";
var xmsgAppUsageOption97=	"Konstrukce strojů ";
var xmsgAppUsageOption98=	"Zásobování výroby / odbyt / marketing ";
var xmsgAppUsageOption40=	"Kreslení topografických a geodetických map ";
var xmsgAppUsageOption41=	"Projektování mechanických systémů (vytápění, ventilace, klimatizace a potrubí) ";
var xmsgAppUsageOption42=	"Projektování vodovodních a/nebo protipožárních systémů ";
var xmsgAppUsageOption43=	"Konstrukce technologických celků a elektráren ";
var xmsgAppUsageOption44=	"Výstavba nemovitostí ";
var xmsgAppUsageOption45=	"Statické výpočty a posudky ";
var xmsgAppUsageOption87=	"Telekomunikace ";
var xmsgAppUsageOption46=	"Nástrojárna / strojírna ";
var xmsgAppUsageOption47=	"Projektování dopravních systémů ";
var xmsgAppUsageOption48=	"Inženýrské sítě: elektřina, nafta a plyn ";
var xmsgAppUsageOption49=	"Inženýrské sítě: voda a kanalizace ";
var xmsgAppUsageOption99=	"Jiné ";

var xmsgWrongCountryCodeMsg=	"Chyba: Nezadán žádný známý kód země!";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "Verze:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"Svoji žádost podám faxem nebo telefonicky"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"Registrace poštou.";
var xmsgAccessHereMsg=		"zde.";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "Chtěl bych získat kód prostřednictvím:";
var xmsgReceiveCodeMsg1=     "Chci obdržet aktivační soubor e-mailem"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"Vyčkejte, probíhá ověření <br>vaší licence.";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "Požadované informace o produktu"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "Chcete-li aktivovat svoji licenci k produktu %1, zadejte sériové číslo a klíč k produktu, který se nachází na balení produktu nebo v e-mailu s informacemi o aktualizacích nebo licencích k produktům Autodesk.";
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"Získat síťovou licenci";
var xmsgNSARTBeginMsg1=		"Vyžádat soubor pro aktivaci síťové licence prostřednictvím:";
var xmsgNSARTBeginMsg2=		"Přímé připojení (prostřednictvím Internetu)";
var xmsgNSARTBeginMsg3=		"Podat žádost e-mailem, faxem nebo telefonicky";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"Informace serveru";
var xmsgEditServerHdrMsg2=	"Model licenčního serveru*";
var xmsgEditServerMsg1=		"Zadejte informace o vašem licenčním serveru.<br>"+
							"Klepnutím na tlačítko Vyhledat vyplníte pole ID hostitele serveru.<p>";
var xmsgEditServerMsg2=		"Začít s daty hostitelského serveru z existujícího licenčního souboru(ů).";
var xmsgEditServerRemove=	"Odstranit";
var xmsgEditServerHostName=	"Název hostitelského serveru*";
var xmsgEditServerHostID=	"Hostitelské ID*";
var xmsgEditServerSeat=		"Licencí*";
var xmsgEditServerSingle=	"Jediný server";
var xmsgEditServerDistributed=	"Distribuovaný server";
var xmsgEditServerRedundant=	"Redundantní server";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"Vyhledat";
var xmsgEditServerAddServer=	"Přidat";
var xmsgEditServerRemoveServer=	"Odstranit";
var xmsgEditServerTotal=	"Celkem:";
var xmsgEditServerExceedMaxServer=	"Poznámka: Můžete najednou licencovat nejvýše 20 distribuovaných serverů. Pokud potřebujete licencovat více než 20 serverů, obraťte se na společnost Autodesk.";
var xmsgEditServerSeatError=	"Licence musí obsahovat jen číselné údaje.";

var xmsgConfirmServerMsg=	"Ověřte následující informace. Pokračujte stisknutím tlačítka Další nebo stiskněte tlačítko Zpět a proveďte změny.";
var xmsgConfirmServerMsg2=	"Po stisknutí tlačítka Další budou tyto informace odeslány prostřednictvím Internetu společnosti Autodesk.";
var xmsgConfirmServerHdr2=	"Model licenčního serveru:";
var xmsgConfirmServerHostName=	"Název hostitelského serveru";
var xmsgConfirmServerHostID=	"Hostitelské ID";
var xmsgConfirmServerSeat=		"Licencí";
var xmsgConfirmServerTotal=		"Celkem licencí:";

var xmsgLicErrorHdr=			"Chyba licence"; 
var xmsgLicErrorInvalidSN=		"Zadané sériové číslo není platné. Ověřte, zda je výše uvedené sériové číslo správné. Klepněte na jeden z následujících odkazů.";
var xmsgLicReEnterSN=			"Znovu zadejte sériové číslo a zkuste znovu.";

var xmsgLic113Msg2=				"Celkový počet licencí, který jste přiřadili k distribuovaným serverům, přesahuje tento počet.";
var xmsgLic113ModifySeats=		"Upravte distribuci licencí.";

var xmsgSaveLicenseHdr=			"Licence obdržena(y)";
var xmsgSaveLicenseMsg1=		"Obdrželi jste licence od společnosti Autodesk. Nyní je musíte uložit do licenčních souborů.<p> <b>Uložte licence do licenčních souborů.</b><p><LI><b>Doporučené umístění</b> pro licenční soubory je v adresáři „License“, kam jste na vašem serveru nainstalovali Správce síťových licencí Autodesk.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI>Máte-li již <b>existující licenční soubor</b>, <b>vložte</b> do něj tuto novou licenci.<br>Po stisknutí tlačítka Další systém automaticky vloží vaše licenční informace na odpovídající místo v existujícím souboru.</LI>";
var xmsgSaveLicenseMsg2=		"Pokud je výše uvedený soubor existujícím licenčním souborem:";
var xmsgSaveLicenseMsg3=		"Vložit do něj nové licenční informace.";
var xmsgSaveLicenseMsg4=		"Přepsat existující licenční soubor.";
var xmsgSaveLicenseMsg5=		"Opravte následující chyby:";

var xmsgSaveErrorFileNameTooLong=  "CHYBA: Zadaný název souboru je příliš dlouhý.<br>" +
								"Změňte název souboru a pokračujte.";
var xmsgSaveErrorNoPermission=	"CHYBA: Nemáte oprávnění k uložení souboru do určeného umístění.<br>Můžete soubor uložit do dočasného umístění, získat potřebná oprávnění a soubor přesunout později.";
var xmsgSaveErrorNoDiskSpace=	"CHYBA: Nemáte dostatek místa na disku pro uložení souboru do určeného umístění.<BR>Můžete soubor uložit do dočasného umístění, uvolnit místo a soubor přesunout později.";
var xmsgSaveErrorInvalidFile=	"CHYBA: Novou licenci nelze připojit k zadanému souboru bez ztráty dat. Zadaný soubor mohl být určen pro jiné počítače nebo odlišný model serveru.<BR>Nový licenční soubor můžete uložit pod jiným názvem nebo na jiné místo a později jej k souboru připojit ručně.";															
var xmsgSaveErrorPathNotExit=	"CHYBA: Zadaná cesta neexistuje.<BR>Klepněte na Procházet pro nalezení nebo vytvoření této cesty.";
var xmsgSaveErrorPathBlank=		"CHYBA: Musíte určit platnou cestu a název licenčního souboru. Určete cestu a název souboru v níže uvedeném poli nebo zvolte Procházet.";

var xmsgLicAuthConfirmHdr1=		"Úspěšná aktivace licence!";
var xmsgLicAuthConfirmHdr2=		"Informace hostitele licenčního serveru";
var xmsgLicAuthConfirmMsg1=		"Děkujeme vám za registraci vašeho produktu. Můžete si vytisknout záznam těchto informací.";
var xmsgLicAuthConfirmDate=		"Datum:";

var xmsgLicPathMsg1=			"Byly uloženy následující licenční soubory:";
var xmsgLicPathMsg2=			"Vaše licenční soubory byly uloženy do:";

var xmsgOtherMethodMsg1NSA=		"Použijte jiný způsob získání autorizované licence.";
var xmsgOtherMethodMsg1=		"Použijte jiný způsob.";

var xmsgContactAutodeskMsg1=	"Společnost Autodesk můžete kontaktovat některým z následujících způsobů.";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"Získat licenční soubor e-mailem";
var xmsgEmailOptionTitle=		"Registrace e-mailem";
var xmsgEmailOptionNSAMsg=		"Vaše informace o registraci a licenčním serveru byly automaticky uloženy do souboru. Soubor musí být odeslán na středisko automatického zpracování registrací produktů Autodesk.<p>Po úspěšném odeslání souboru e-mailem společnosti Autodesk obdržíte automatickou odpověď, autorizovaný licenční soubor a pokyny pro dokončení procesu.";
var xmsgEmailOptionMsg=			"Vaše informace o registraci byly automaticky uloženy do souboru. Soubor musí být odeslán na středisko automatického zpracování registrací produktů Autodesk.<p>Po úspěšném odeslání souboru e-mailem společnosti Autodesk obdržíte automatickou odpověď a pokyny pro dokončení procesu.";
var xmsgEmailOptionMsg2=		"Pokud vámi používaný výchozí e-mailový systém je nyní schopen odeslat e-mail prostřednictvím internetu, klepněte Odeslat soubor nyní a poté klepněte Další. Soubor bude odeslán automaticky.<p>Pokud nyní nemáte přístup pro odeslání e-mailu, klepněte Odeslat soubor později. Pokyny pro ruční odeslání souboru budou poskytnuty.";
var xmsgEmailOptionInfo1=		"Odeslat soubor nyní.";
var xmsgEmailOptionInfo2=		"Odeslat soubor později, ručně.";
var xmsgEmailOptionInfo3=		"Odeslat kopii e-mailu na zadanou e-mailovou adresu.";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"Nelze vytvořit e-mail";
var xmsgEmailErrorMsg1=			"Registraci e-mailem dokončíte připojením následujícího souboru k e-mailu:";
var xmsgEmailErrorMsg2=			"Odešlete e-mail na adresu %1.";
var xmsgEmailErrorMsg3=			"Soubor naleznete na následujícím místě:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"Změnit zákaznické informace";
var xmsgLocalHEREInfo=			"Chcete-li změnit své zákaznické informace, obraťte se na autorizovaného prodejce společnosti Autodesk nebo přejděte na následující odkaz, který platí pro vaši zemi nebo oblast.";
var xmsgLocalHEREUS=			"Severní a Jižní Amerika";
var xmsgLocalHEREEMEA=			"Evropa, Střední východ, Afrika";
var xmsgLocalHEREAPAC=			"Asie/Tichomoří";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"Nápověda";
var xmsgHelpUpgradeMsg=			"Pokud registrujete nebo aktivujete upgrade z předchozí verze, musíte zaškrtnout toto políčko, přičemž budete vyzváni k zadání sériového čísla verze, ze které provádíte upgrade.";
var xmsgHelpUpgradeRequiredTitle=	"Zadejte sériové číslo předchozího produktu (vyžadováno pro upgrade)";
var xmsgHelpUpgradeRequiredMsg=	"Jedná se o sériové číslo předchozí verze softwaru. Sériové číslo naleznete v dialogovém okně O aplikaci (nabídka Nápověda) nebo na balení předchozího produktu.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"Nezadali jste %1. Pokud chcete aktivaci získat tímto způsobem, zadejte tento údaj.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "Sériové číslo/ID skupiny"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "Vaše sériové číslo je uvedeno na obalu produktu nebo v e-mailu s informacemi o aktualizaci nebo licenci produktů Autodesk."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "Klíč produktu";
var xmsgHelpProductKeyMsg=    "Klíč produktu se nachází vedle sériového čísla na balení produktu nebo v e-mailu s informacemi o aktualizaci nebo licenci produktů Autodesk."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"Chyba připojení (0.15)";
var xmsgRT010203071213CannotCompErrA=	"Chyba registrace (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"Již zaregistrován (9)";
var xmsgRT10ExceededAuths=				"Překročeny autorizace (10)";
var xmsgRT12StolenSN=					"Odcizené sériové číslo (12)";
var xmsgRT18OldSNInvalid=				"Předchozí sériové číslo je neplatné (18)";
var xmsgRT20DataError=					"Chyba dat (20)";
var xmsgRT21CustIDTelErr=				"Chyba ID/tel zákazníka (21)";
var xmsgRT22NetworkInstallation=		"Chyba síťové instalace (22)";
var xmsgRT900SystemNotResponding=		"Systém neodpovídá (900)";
var xmsgRTCustID=						"ID zákazníka";
var xmsgRTCustIDConfirm=				"Potvrzení identifikace";
var xmsgRTNewSerialNumber=				"Informace o novém sériovém čísle";
var xmsgRTNoNewSN=						"Chyba nákupní transakce";
var xmsgRTPurchAuthFailed=				"Chyba aktivace";
var xmsgRTPurchConfirmOther=			"Potvrzení nákupu";
var xmsgRTPurchConfirmPerm=				"Potvrzení nákupu – Registrován a aktivován";
var xmsgRTPurchConfirmReg=				"Potvrzení nákupu – Registrován ale neaktivován";
var xmsgRTPurchConfirmRegVol=			"Potvrzení nákupu – Registrován";
var xmsgRTPurchConfirmRent=				"Potvrzení nákupu – Registrován a aktivní pronájem";
var xmsgRTPurchConfirmUnReg=			"Potvrzení nákupu – Neregistrován ani neaktivován";
var xmsgRTPurchConnectionFailed=		"Nákupní připojení selhalo";
var xmsgRTPurchaseError=				"Chyba nákupu";
var xmsgRTSNMismatch=					"Chyba nákupní transakce – Nesouhlas sériového čísla";
var xmsgRTSUNOldSNInvalid=				"Předchozí sériové číslo neplatné – SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"Konec";

var xmsgCustIDMainTitle=	"Identifikace zákazníka";
var xmsgCustIDTitle1=		"ID zákazníka:";
var xmsgCustIDText2=		"Zadejte vaše ID zákazníka a telefonní číslo. Pokud nemáte ID zákazníka, ponechte obě pole prázdná.<p> ";
var xmsgCustIDText3=		"Poznámka: Pokud reaktivujete váš produkt, musíte zadat ID zákazníka (Customer ID).";
var xmsgCustIDText3NSA=		"Poznámka: Pokud reautorizujete váš produkt, musíte zadat ID zákazníka (Customer ID).";
var xmsgCustIDTitle2=		"Telefonní číslo:";
var xmsgCustIDTelEx4=		"(příklad: 03-111-1234)";
var xmsgRegCustIDTel=		"Zadané ID zákazníka a telefonní číslo neodpovídají našim záznamům. Klepněte na jeden z následujících odkazů.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"Naše záznamy ukazují, že máte k dispozici %1 platných licencí %2.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"Zadané sériové číslo je neplatné";
var xmsgErr12APAC=				"<p>Toto sériové číslo je neplatné a nelze je aktivovat. Kontaktujte nás na adrese <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>Vážený zákazníku,</p><p>děkujeme vám za zájem o registraci produktu Autodesk&#0174; nebo Discreet&#0153; u společnosti Autodesk.</p><p>Podle našich záznamů však bohužel sériové číslo produktu Autodesk&#0174; nebo Discreet&#0153;, které se snažíte zaregistrovat, není platným sériovým číslem nebo se jedná o sériové číslo pirátské kopie tohoto produktu a produkt Autodesk&#0174; nebo Discreet&#0153;, který používáte, proto nebude autorizován.</p><p>Licence k používání produktů Autodesk&#0174; lze zakoupit u autorizovaných prodejců společnosti Autodesk – na adrese <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> získáte seznam autorizovaných prodejců společnosti Autodesk nebo kontakt na kancelář společnosti Autodesk ve vaší oblasti. Používání legálního softwaru je jediným způsobem, jakým si můžete zajistit maximální prospěch z používání softwaru a předejít možnému občanskému a trestnímu stíhání, pokud budete přistiženi při nezákonném používání anebo rozmnožování softwaru.</p><p>Licence k používání produktů Discreet&#0153; lze zakoupit u autorizovaných prodejců společnosti Discreet – na adrese <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> naleznete seznam autorizovaných prodejců společnosti Discreet nebo kontakt na kancelář společnosti Discreet ve vaší oblasti. Používání legálního softwaru je jediným způsobem, jakým si můžete zajistit maximální užitek z používání softwaru a předejít možnému občanskému a trestnímu stíhání kvůli nezákonnému používání anebo rozmnožování softwaru.</p><p>Z tohoto důvodu vás laskavě žádáme, abyste okamžitě přestali používat neautorizovaný produkt, který se u naší společnosti snažíte registrovat, odstranili veškeré kopie uložené ve vašem počítačovém hardwaru a zničili všechna média obsahující tento produkt. Přestože věříme, že naší žádosti dobrovolně vyhovíte, s ohledem na tuto skutečnost si společnost Autodesk vyhrazuje svá práva a může předat vaše údaje organizaci Business Software Alliance („BSA“).</p><p>Pokud máte jakékoli otázky nebo se domníváte, že jste tuto zprávu obdrželi omylem, kontaktujte nás na následující adrese: <a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a></p><p>Pokud chcete poskytnout informace týkající se používání nebo prodeje nelegálního softwaru, kontaktujte místní kancelář společnosti Autodesk nebo organizaci BSA na adrese <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Děkujeme.</p>";
var xmsgErr12US=				"<p>Vážený zákazníku</p><p>Děkujeme vám za snahu zaregistrovat produkt Autodesk&#0174; nebo Discreet&#0153; u společnosti Autodesk nebo Discreet.</p><p>Podle našich záznamů však bohužel sériové číslo produktu Autodesk&#0174; nebo Discreet&#0153;, které se snažíte zaregistrovat, není platné sériové číslo nebo se jedná o sériové číslo pirátské kopie tohoto produktu a produkt Autodesk&#0174; nebo Discreet&#0153;, který používáte, proto nebude autorizován.</p><p>Licence k používání produktů Autodesk&#0174; lze zakoupit u autorizovaných prodejců společnosti Autodesk – jejich seznam i kontakt na kancelář společnosti Autodesk ve vaší oblasti naleznete na adrese <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>. Používání legálního softwaru je jediným způsobem, jakým si můžete zajistit maximální prospěch z používání softwaru A předejít možnému občanskému a trestnímu stíhání, pokud budete přistiženi při nezákonném používání anebo rozmnožování softwaru.</p><p>Licence k používání produktů Discreet&#0153; lze zakoupit u autorizovaných prodejců společnosti Discreet – na adrese <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> získáte seznam autorizovaných prodejců společnosti Discreet nebo kontakt na kancelář společnosti Discreet ve vaší oblasti. Používání legálního softwaru je jediným způsobem, jakým si můžete zajistit maximální prospěch z používání softwaru a předejít možnému občanskému a trestnímu stíhání kvůli nezákonnému používání anebo rozmnožování softwaru.</p><p>Z tohoto důvodu vás laskavě žádáme, abyste okamžitě přestali používat neautorizovaný produkt, který se u naší společnosti snažíte registrovat, odstranili veškeré kopie uložené ve vašem počítačovém hardwaru a zničili všechna média obsahující tento produkt. Přestože věříme, že naší žádosti dobrovolně vyhovíte, s ohledem na tuto skutečnost si společnost Autodesk vyhrazuje svá práva a může předat vaše údaje organizaci Business Software Alliance („BSA“).</p><p>Pokud máte jakékoli otázky nebo se domníváte, že jste tuto zprávu obdrželi omylem, kontaktujte nás na následující adrese: <a href=mailto:Authcodes.neu@autodesk.com target=\"_blank\">Authcodes.neu@autodesk.com</a></p><p>Pokud chcete poskytnout informace týkající se používání nebo prodeje nelegálního softwaru, kontaktujte místní kancelář společnosti Autodesk nebo organizaci BSA na adrese <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Děkujeme</p>";
// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFDJ9cuzHHG2U
// SIG // xN5tB/QcDEqhdsvroIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEHS8VusbS9oziV7CM3V8XDMwDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDkw
// SIG // MzEwMDAwMDAwWhcNMTAwNDA5MjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAmeyo
// SIG // XUqsM3gsliL4M1tThOIixcSmppT1AI04curyMTgKCrT6
// SIG // vIaC74ZsEki5wseN6FoAwzeZUJZWPbbPV0qekjTQySBs
// SIG // OYONAd1oU3S2a86Cujy+zxcfryQA+GqYZuG+j1SsLUy5
// SIG // ASBEv4zkQjfWpHMOI8JRdQr2RgVJ/C3LvFcCAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAEhMhyHuuFsZagEh6O0zAq+6z0EuhaaqI
// SIG // A/hY0xRjZSyBSoQGwwX1pcNyaFf4TTm/xobUutgT7Ct+
// SIG // l/Xl+RbntwVRkyMSKWGX4CtIKuR70vdqREuNEW9exz0M
// SIG // Ck+lZlPZupJe/OA9cZr1x2M296RHRXKK8lCaE5bexPD/
// SIG // k462NFYSZYfs0DwBMz9Ui+kiFcjnsnUpTGoAI7/Xg6Bn
// SIG // t7tzXU5emeIw9AIZt+64XKOvh5BL1VJ/WuD2rjqCwBBP
// SIG // 4NRD2cOa905LKi0qNHp9KyZPE8IJIK2XgTTX9L+Cw7mT
// SIG // Q2kmYtBmz/9/xjeIVrbwEqZeEfbLiSW2QRysH5RA7oou
// SIG // UjGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhB0vFbrG0vaM4lewjN1fFwzMAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFPO8ZkTN/dxocX/C1zViFH7crAqkMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYB4
// SIG // 1/vf7CD8q308lO+RWZTj/CxAT0ARAGPgRPKjnsGxxPDO
// SIG // GYJhGfLHjIbyikhSwkpAUUXCLLnOZt1KMCqyQoQa6Uro
// SIG // J87nvIC1oQIcyBeGfARh2FTIGBBMfiX8TUE8grrQ4BDV
// SIG // KENO0/48+riM5hTlCKcGnW2CibBZIh51Llz3lqGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkxMTIwMDAwNzE1
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUZbCRexBdc0LxLZ0cQ7dn
// SIG // FGTjorwwDQYJKoZIhvcNAQEBBQAEgYBPqXJrbQBZqBWQ
// SIG // 9z3FL88TRD1j5DnVw/OKlvAv5pfAldOzoJDXo+flKvyQ
// SIG // JKlPffG0trx/L3MEijgXwK7hZ+TqmJbgeQ7pJX+tdsBk
// SIG // mbhOpIPsglUH3upXugPAo2GM2I/l/YF3xYssxZR9qKvC
// SIG // Bm9PcZKIsuTKyZRgcmqZOQX/mA==
// SIG // End signature block
